﻿using Azyobuzi.Twikoto2.Models;
using Livet;

namespace Azyobuzi.Twikoto2.ViewModels
{
    public class QueryViewModel : ViewModel
    {
        /*コマンド、プロパティの定義にはそれぞれ 
         * 
         *  ldcom   : DelegateCommand(パラメータ無)
         *  ldcomn  : DelegateCommand(パラメータ無・CanExecute無)
         *  ldcomp  : DelegateCommand(型パラメータ有)
         *  ldcompn : DelegateCommand(型パラメータ有・CanExecute無)
         *  lprop   : 変更通知プロパティ
         *  
         * を使用してください。
         */

        /*ViewModelからViewを操作したい場合は、
         * Messengerプロパティからメッセージ(各種InteractionMessage)を発信してください。
         */

        /*
         * UIDispatcherを操作する場合は、DispatcherHelperのメソッドを操作してください。
         * UIDispatcher自体はApp.xaml.csでインスタンスを確保してあります。
         */

        /*
         * Modelからの変更通知などの各種イベントをそのままViewModelで購読する事はメモリリークの
         * 原因となりやすく推奨できません。ViewModelHelperの各静的メソッドの利用を検討してください。
         */

        public QueryViewModel()
        {
            this.Model = new Query();
            ViewModelHelper.BindNotifyChanged(
                this.Model,
                this,
                (sender, e) => this.RaisePropertyChanged(e.PropertyName));
        }

        public Query Model { private set; get; }

        public TimelineTypes Type
        {
            set
            {
                this.Model.Type = value;
            }
            get
            {
                return this.Model.Type;
            }
        }

        public string Parameter
        {
            set
            {
                this.Model.Parameter = value;
            }
            get
            {
                return this.Model.Parameter;
            }
        }
        
        string _Name;

        public string Name
        {
            get
            { return _Name; }
            set
            {
                if (_Name == value)
                    return;
                _Name = value;
                RaisePropertyChanged("Name");
            }
        }
      
    }
}
